import { world, system, EntityDamageCause } from '@minecraft/server';

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:garpite', {
        onEntityFallOn: ({ block, entity }) => {
            block.dimension.runCommand(`setblock ${Object.values(block.location).join(' ')} air destroy`);
            entity.applyDamage(1, { cause: EntityDamageCause.fall });
        }
    })
})
